# Simple API Sample

A minimal, beginner-friendly sample demonstrating the Eriksson Beam API.

## What This Sample Does

This console application shows the basic API workflow:

1. **Launch** - Start Eriksson Beam with a project file
2. **Pull** - Retrieve current design data
3. **Modify** - Change project information properties
4. **Push** - Send changes back to Eriksson Beam

## Prerequisites

- **Eriksson Beam** desktop application installed
- **API License Key** (contact Eriksson Software)
- **.NET Framework 4.8** SDK
- **Visual Studio 2019+** or VS Code with C# extension
- A beam project file (`.ebf`) to work with

## Setup Instructions

### 1. Configure the NuGet Package Source

The API is distributed as a NuGet package. Update `SimpleApiSample/nuget.config` with the correct path to your package source:

```xml
<add key="ErikssonBeamLocal" value="C:\YOUR\PATH\TO\PACKAGE" />
```

### 2. Update Configuration in Program.cs

Open `SimpleApiSample/Program.cs` and update these values:

```csharp
var licenseKey = "YOUR_LICENSE_KEY_HERE";
var projectFilePath = @"C:\Path\To\Your\Project.ebf";
```

### 3. Build and Run

**Visual Studio:**
1. Open `SimpleApiSample.sln`
2. Build solution (Ctrl+Shift+B)
3. Run (F5)

**Command Line:**
```bash
dotnet restore
dotnet build
dotnet run --project SimpleApiSample
```

## Important Notes

- **Platform Target**: This project targets x86. If you create your own project, ensure it also targets x86.
- **Connection Timeout**: Eriksson Beam only listens for API connections for 10 minutes after launch.
- **Always Pull First**: Never create a BeamDesign object directly. Always pull to preserve existing data.
- **Batch Changes**: Make all modifications before calling Push to minimize overhead.

## Next Steps

- Read the [full documentation](https://green-plant-030f9990f.azurestaticapps.net/getting-started/)
- Explore the [API reference](https://green-plant-030f9990f.azurestaticapps.net/api/)
- See [common tasks](https://green-plant-030f9990f.azurestaticapps.net/guides/common-tasks/) for more examples

## Troubleshooting

**"Package not found" error:**
- Verify the path in `nuget.config` points to your NuGet package folder
- Run `dotnet nuget locals all --clear` to clear cache

**"Could not load file or assembly" error:**
- Ensure project targets x86 platform
- Verify .NET Framework 4.8 is installed

**Connection timeout:**
- Restart Eriksson Beam (connection window is 10 minutes)
- Check that your license key is valid

## License

This sample is provided for demonstration purposes.
